/**************************************************************************/
/* FILE NAME:                              COPYRIGHT (c) Freescale 2008   */
/* MPC56xx_55xx_Dual_PRC0_Interrupt_Init.c        All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION:                                                           */
/* This is the interrupt controller configuration file.                   */
/*=========================================================================*/
/*                                                                        */
/*========================================================================*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
/* ---   -----------    ----------    ---------------------               */
/* 0.1    R. Moran       10/12/2008    Initial Version                    */
/**************************************************************************/
#include "mpc5668.h"

/*========================================================================*/
/*                      GLOBAL VARIABLES                                  */
/*========================================================================*/

extern const uint32_t IntcIsrVectorTable[];

/*========================================================================*/
/*                      EXTERNAL PROTOTYPES                               */
/*========================================================================*/

extern void e200zX_Interrupt_Setup (void);

/*========================================================================*/
/*                          FUNCTIONS                                     */
/*========================================================================*/

/**************************************************************************/
/* FUNCTION     : InitINTC                                                */
/* PURPOSE      : This function intializes the INTC for software vector   */
/*                mode.                                                   */
/**************************************************************************/
void InitINTC(void) {   
    
    /* Choose software (HVEN=0) or hardware (HVEN=1) vector mode */
	/* MCR: Module configuration register ->  */
    INTC.MCR.B.HVEN_PRC0 = 0;
        
    /* Use the default vector table entry offsets of 4 bytes */
    INTC.MCR.B.VTES_PRC0 = 0;
    
    /* Set INTC ISR vector table base addr. */
	/* IACKR_PRC0: Interrupt Acknowledge Register for Z6 */
    INTC.IACKR_PRC0.R = (uint32_t) &IntcIsrVectorTable[0]; 
}

/**************************************************************************/
/* FUNCTION     : enableIrq                                               */
/* PURPOSE      : This function sets INTC's current priority to 0.        */
/*                External interrupts to the core are enabled.            */
/**************************************************************************/
void enableIrq(void) {
    
    /* Ensure INTC's current priority is 0 */
	/* CPR: Current priority register */
    INTC.CPR_PRC0.B.PRI = 0;
    
    // Enable external interrupts in core
    asm(" wrteei 1");       
}

/**************************************************************************/
/* FUNCTION     : xcptn_xmpl                                              */
/* PURPOSE      : This function sets up the necessary functions to raise  */
/*                and handle a SWT Interrupt in hardware vector mode      */
/**************************************************************************/
void xcptn_xmpl(void) {
    
    // Initialise Core IVPR and IVOR Registers
    e200zX_Interrupt_Setup();       
    
    // Initialize INTC for hardware vector mode
    InitINTC();               
    
    // Initialise Interrupt Priorities - set in "ISR_Routines.c"
    Init_INTC_Priority();

}


